/**************************************************************************************************
 * Private header file for the Keyboard driver.
 *
 * Freescale Semiconductor Inc.
 * (c) Copyright 2004-2012 Freescale Semiconductor, Inc.
 * ALL RIGHTS RESERVED.
 *
***************************************************************************************************
 *
 * THIS SOFTWARE IS PROVIDED BY FREESCALE "AS IS" AND ANY EXPRESSED OR 
 * IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES 
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.  
 * IN NO EVENT SHALL FREESCALE OR ITS CONTRIBUTORS BE LIABLE FOR ANY DIRECT, 
 * INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES 
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR 
 * SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) 
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, 
 * STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING 
 * IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF 
 * THE POSSIBILITY OF SUCH DAMAGE.
 *
***********************************************************************************************//*!
**************************************************************************************************/

#ifndef KEYBOARD_INTERFACE_H_
#define KEYBOARD_INTERFACE_H_

/************************************************************************************
*************************************************************************************
* Includes
*************************************************************************************
************************************************************************************/

#include "EmbeddedTypes.h"
#include "PortConfig.h"

/************************************************************************************
*************************************************************************************
* Private macros
*************************************************************************************
************************************************************************************/

/************************************************************************************
*************************************************************************************
* Private prototypes
*************************************************************************************
************************************************************************************/

/************************************************************************************
*************************************************************************************
* Private type definitions
*************************************************************************************
************************************************************************************/

/************************************************************************************
*************************************************************************************
* Private memory declarations
*************************************************************************************
************************************************************************************/

/***********************************************************************************/

/************************************************************************************
*************************************************************************************
* Public macros
*************************************************************************************
************************************************************************************/

#ifndef gKeyboardSupported_d
 #define gKeyboardSupported_d     TRUE
#endif    

/************************************************************************************ 
* Select Rising or Falling edge event detection
************************************************************************************/

#define gKeyboardRisingEdge_c                0
#define gKeyboardFallingEdge_c               1

/************************************************************************************ 
* The following checks are to make sure a valid keyboard option is selected 
************************************************************************************/

#if (gKeyboardRisingEdge_c & gKeyboardFallingEdge_c) 
#error "Keyboard Edge selection error [select Falling Edge OR Rising Edge]"
#endif

#if (gKeyboardRisingEdge_c ==0 && gKeyboardFallingEdge_c==0)                              
#error "Keybaord Edge selection error [select Falling Edge OR Rising Edge]"
#endif

/************************************************************************************
*************************************************************************************
* Public prototypes
*************************************************************************************
************************************************************************************/

/************************************************************************************
*************************************************************************************
* Public type definitions
*************************************************************************************
************************************************************************************/

typedef enum keyboardErr_tag{
  gKeyboardErrorNoError_c = 0,
  gKeyboardErrorNullPointer_c
} keyboardErr_t;

typedef uint8_t keyboardPressed_t;

/*Keyboard callback pointer definition
* This callback function will be called when a Keyboard event is detected 
* It's called in the Keyboard's (PORT) interrupt context.
*/
typedef void(* keyboardCallback_t)(keyboardPressed_t);

/************************************************************************************
*************************************************************************************
* Public memory declarations
*************************************************************************************
************************************************************************************/
  
  
/******************************************************************************
*******************************************************************************
* Public functions
*******************************************************************************
*******************************************************************************/


/******************************************************************************
* Keyboard_Init - initializes the Keyboard variables and configures the Keyboard 
* ports with the specified default values
*
* Interface assumptions:
*   NONE
*
* return value:
*   
*   gGpioErrNoError_c - When the function is successfully performed
*   gKeyboardErrorNullPointer - When the pointer to the CallBack function is NULL
*
* Effects on global data:
*   NONE
*
*******************************************************************************/

extern keyboardErr_t Keyboard_Init
(
  keyboardCallback_t   /*IN: Callback function to start after Keyboard interrupt*/
); 
   
/************************************************************************************
* Keyboard interrupt
*
* The purpose of this interrupt is to call the Callback function.
* 
************************************************************************************/ 

  void Keyboard1_Interrupt (void);
  void Keyboard2_Interrupt (void);      

/*************************************************************************************************/

#endif /* KEYBOARD_INTERFACE_H_ */
